/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.dyeable_redstone_signal.common.block.entity;

import com.google.common.collect.ImmutableMap;
import com.hexagram2021.dyeable_redstone_signal.common.block.ColorfulRedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.block.CommonRedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.crafting.RedstoneDyerMenu;
import com.hexagram2021.dyeable_redstone_signal.common.register.DRSBlockEntities;
import com.hexagram2021.dyeable_redstone_signal.common.register.DRSBlocks;
import com.hexagram2021.dyeable_redstone_signal.common.register.DRSItemTags;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class RedstoneDyerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
StackedContentsCompatible {
    public static final int SLOT_INPUT = 0;
    public static final int DYE_INPUT = 1;
    public static final int SLOT_RESULT = 2;
    public static final int DATA_FLUID = 0;
    public static final int DATA_DYE_TYPE = 1;
    public static final int DATA_TODO = 2;
    public static final int FLUID_PER_DYE = 5;
    public static final int MAX_FLUID_LEVEL = 50;
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1, 0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2};
    int fluid;
    int dye;
    int todo;
    protected NonNullList<ItemStack> items = NonNullList.m_122780_((int)3, (Object)ItemStack.f_41583_);
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RedstoneDyerBlockEntity.this.fluid;
                case 1 -> RedstoneDyerBlockEntity.this.dye;
                case 2 -> RedstoneDyerBlockEntity.this.todo;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RedstoneDyerBlockEntity.this.fluid = value;
                    break;
                }
                case 1: {
                    RedstoneDyerBlockEntity.this.dye = value;
                    break;
                }
                case 2: {
                    RedstoneDyerBlockEntity.this.todo = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    public static final byte[][] COLOR_MIX = new byte[][]{{0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, -1}, {-1, 1, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, 12, 6, -1}, {-1, -1, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, -1}, {-1, 3, -1, -1, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, 8, -1}, {-1, -1, -1, -1, -1, -1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, 8, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, 9, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 11, 9, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 9, 12, -1, -1, -1}, {-1, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 13, 11, 10}, {4, 6, -1, -1, 7, 8, -1, -1, -1, -1, -1, -1, -1, 11, 14, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, -1, 15}};
    public static final Map<DyeColor, Integer> DYE_INDEX = ImmutableMap.builder().put((Object)DyeColor.BLACK, (Object)0).put((Object)DyeColor.BLUE, (Object)1).put((Object)DyeColor.BROWN, (Object)2).put((Object)DyeColor.CYAN, (Object)3).put((Object)DyeColor.GRAY, (Object)4).put((Object)DyeColor.GREEN, (Object)5).put((Object)DyeColor.LIGHT_BLUE, (Object)6).put((Object)DyeColor.LIGHT_GRAY, (Object)7).put((Object)DyeColor.LIME, (Object)8).put((Object)DyeColor.MAGENTA, (Object)9).put((Object)DyeColor.ORANGE, (Object)10).put((Object)DyeColor.PINK, (Object)11).put((Object)DyeColor.PURPLE, (Object)12).put((Object)DyeColor.RED, (Object)13).put((Object)DyeColor.WHITE, (Object)14).put((Object)DyeColor.YELLOW, (Object)15).build();
    public static final DyeColor[] DYE_COLORS = new DyeColor[]{DyeColor.BLACK, DyeColor.BLUE, DyeColor.BROWN, DyeColor.CYAN, DyeColor.GRAY, DyeColor.GREEN, DyeColor.LIGHT_BLUE, DyeColor.LIGHT_GRAY, DyeColor.LIME, DyeColor.MAGENTA, DyeColor.ORANGE, DyeColor.PINK, DyeColor.PURPLE, DyeColor.RED, DyeColor.WHITE, DyeColor.YELLOW};
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.redstone_dyer");
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public RedstoneDyerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)DRSBlockEntities.REDSTONE_DYER.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.fluid = nbt.m_128451_("Fluid");
        this.dye = nbt.m_128451_("DyeColor");
        this.todo = nbt.m_128451_("ToDo");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Fluid", this.fluid);
        nbt.m_128405_("DyeColor", this.dye);
        nbt.m_128405_("ToDo", this.todo);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
    }

    public static void tryMixDye(RedstoneDyerBlockEntity blockEntity, int fuelIndex, ItemStack fuel) {
        int count;
        if (blockEntity.fluid % 5 == 0 && blockEntity.fluid * 2 <= 50 && (count = blockEntity.fluid / 5) <= fuel.m_41613_()) {
            int mixIndex = COLOR_MIX[blockEntity.dye][fuelIndex];
            if (mixIndex < 0) {
                return;
            }
            fuel.m_41774_(count);
            blockEntity.dye = mixIndex;
            blockEntity.fluid += 5 * count;
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, RedstoneDyerBlockEntity blockEntity) {
        DyeColor current;
        ItemStack fuel = (ItemStack)blockEntity.items.get(1);
        if (!fuel.m_41619_() && DYE_INDEX.containsKey(current = DyeColor.getColor((ItemStack)fuel))) {
            int fuelIndex = DYE_INDEX.get(current);
            if (blockEntity.fluid <= 0) {
                fuel.m_41774_(1);
                blockEntity.dye = fuelIndex;
                blockEntity.fluid += 5;
            } else if (fuelIndex == blockEntity.dye) {
                if (blockEntity.fluid + 5 <= 50) {
                    fuel.m_41774_(1);
                    blockEntity.fluid += 5;
                }
            } else {
                RedstoneDyerBlockEntity.tryMixDye(blockEntity, fuelIndex, fuel);
            }
        }
        ItemStack ingredient = (ItemStack)blockEntity.items.get(0);
        ItemStack result = (ItemStack)blockEntity.items.get(2);
        if (!ingredient.m_41619_() && blockEntity.fluid > 0) {
            BlockItem blockItem;
            Item item;
            if (ingredient.m_204117_(DRSItemTags.DYED_REDSTONES) && (item = ingredient.m_41720_()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof ColorfulRedstoneWireBlock) {
                ColorfulRedstoneWireBlock wireBlock = (ColorfulRedstoneWireBlock)item;
                byte mixIndex = COLOR_MIX[blockEntity.dye][wireBlock.getColorIndex()];
                if (mixIndex >= 0) {
                    Item redstone = DRSBlocks.getColorfulRedstoneWire(mixIndex).m_5456_();
                    if (result.m_41619_()) {
                        ingredient.m_41774_(1);
                        --blockEntity.fluid;
                        blockEntity.items.set(2, (Object)new ItemStack((ItemLike)redstone));
                    } else if (result.m_150930_(redstone)) {
                        ingredient.m_41774_(1);
                        --blockEntity.fluid;
                        result.m_41769_(1);
                    }
                }
            } else if (ingredient.m_150930_(((CommonRedstoneWireBlock)((Object)DRSBlocks.COMMON_REDSTONE_WIRE.get())).m_5456_()) || ingredient.m_150930_(Items.f_42451_)) {
                Item redstone = DRSBlocks.getColorfulRedstoneWire(blockEntity.dye).m_5456_();
                if (result.m_41619_()) {
                    ingredient.m_41774_(1);
                    --blockEntity.fluid;
                    blockEntity.items.set(2, (Object)new ItemStack((ItemLike)redstone));
                } else if (result.m_150930_(redstone)) {
                    ingredient.m_41774_(1);
                    --blockEntity.fluid;
                    result.m_41769_(1);
                }
            }
        }
        switch (blockEntity.todo) {
            case 1: {
                if (blockEntity.fluid <= 0) {
                    blockEntity.fluid = 0;
                    blockEntity.todo = 0;
                }
                --blockEntity.fluid;
                if (blockEntity.fluid % 5 != 0) break;
                blockEntity.todo = 0;
                break;
            }
            case 2: {
                if (blockEntity.fluid <= 0) {
                    blockEntity.fluid = 0;
                    blockEntity.todo = 0;
                }
                --blockEntity.fluid;
                if (blockEntity.fluid != 0) break;
                blockEntity.todo = 0;
            }
        }
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        if (direction == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return SLOTS_FOR_SIDES;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void m_5809_(StackedContents contents) {
        for (ItemStack itemstack : this.items) {
            contents.m_36491_(itemstack);
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack itemStack) {
        this.items.set(index, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_7013_(int index, ItemStack itemStack) {
        return switch (index) {
            case 0 -> {
                if (itemStack.m_150930_(Items.f_42451_) || itemStack.m_150930_(((CommonRedstoneWireBlock)((Object)DRSBlocks.COMMON_REDSTONE_WIRE.get())).m_5456_()) || itemStack.m_204117_(DRSItemTags.DYED_REDSTONES)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> itemStack.m_204117_(Tags.Items.DYES);
            default -> false;
        };
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, ItemStack itemStack, Direction direction) {
        return true;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new RedstoneDyerMenu(id, inventory, (Container)this, this.dataAccess);
    }
}

